/* -*- Mode: Java; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set shiftwidth=2 tabstop=2 autoindent cindent expandtab: */
/* Copyright 2012 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

//var DEFAULT_URL = 'data:application/pdf;base64,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';
var DEFAULT_SCALE = 'auto';
var DEFAULT_SCALE_DELTA = 1.1;
var UNKNOWN_SCALE = 0;
var CACHE_SIZE = 20;
var CSS_UNITS = 96.0 / 72.0;
var SCROLLBAR_PADDING = 40;
var VERTICAL_PADDING = 5;
var MIN_SCALE = 0.25;
var MAX_SCALE = 4.0;
var IMAGE_DIR = './js/pdf_js/web/images/';
var SETTINGS_MEMORY = 20;
var ANNOT_MIN_SIZE = 10;
var RenderingStates = {
  INITIAL: 0,
  RUNNING: 1,
  PAUSED: 2,
  FINISHED: 3
};
var FindStates = {
  FIND_FOUND: 0,
  FIND_NOTFOUND: 1,
  FIND_WRAPPED: 2,
  FIND_PENDING: 3
};

//#if (FIREFOX || MOZCENTRAL || B2G || GENERIC || CHROME)
//PDFJS.workerSrc = '../build/pdf.js';
//#endif

var mozL10n = document.mozL10n || document.webL10n;

function getFileName(url) {
  var anchor = url.indexOf('#');
  var query = url.indexOf('?');
  var end = Math.min(
    anchor > 0 ? anchor : url.length,
    query > 0 ? query : url.length);
  return url.substring(url.lastIndexOf('/', end) + 1, end);
}

function scrollIntoView(element, spot) {
  // Assuming offsetParent is available (it's not available when viewer is in
  // hidden iframe or object). We have to scroll: if the offsetParent is not set
  // producing the error. See also animationStartedClosure.
  var parent = element.offsetParent, offsetY = element.offsetTop;
  if (!parent) {
    error('offsetParent is not set -- cannot scroll');
  }
  while (parent.clientHeight == parent.scrollHeight) {
    offsetY += parent.offsetTop;
    parent = parent.offsetParent;
    if (!parent)
      return; // no need to scroll
  }
  if (spot)
    offsetY += spot.top;
  parent.scrollTop = offsetY;
}

var Cache = function cacheCache(size) {
  var data = [];
  this.push = function cachePush(view) {
    var i = data.indexOf(view);
    if (i >= 0)
      data.splice(i);
    data.push(view);
    if (data.length > size)
      data.shift().destroy();
  };
};

var ProgressBar = (function ProgressBarClosure() {

  function clamp(v, min, max) {
    return Math.min(Math.max(v, min), max);
  }

  function ProgressBar(id, opts) {

    // Fetch the sub-elements for later
    this.div = document.querySelector(id + ' .progress');

    // Get options, with sensible defaults
    this.height = opts.height || 100;
    this.width = opts.width || 100;
    this.units = opts.units || '%';

    // Initialize heights
    this.div.style.height = this.height + this.units;
  }

  ProgressBar.prototype = {

    updateBar: function ProgressBar_updateBar() {
      if (this._indeterminate) {
        this.div.classList.add('indeterminate');
        return;
      }

      var progressSize = this.width * this._percent / 100;

      if (this._percent > 95)
        this.div.classList.add('full');
      else
        this.div.classList.remove('full');
      this.div.classList.remove('indeterminate');

      this.div.style.width = progressSize + this.units;
    },

    get percent() {
      return this._percent;
    },

    set percent(val) {
      this._indeterminate = isNaN(val);
      this._percent = clamp(val, 0, 100);
      this.updateBar();
    }
  };

  return ProgressBar;
})();

//#if FIREFOX || MOZCENTRAL
//#include firefoxcom.js
//#endif

// Settings Manager - This is a utility for saving settings
// First we see if localStorage is available
// If not, we use FUEL in FF
// Use asyncStorage for B2G
var Settings = (function SettingsClosure() {
  var isLocalStorageEnabled = (function localStorageEnabledTest() {
    // Feature test as per http://diveintohtml5.info/storage.html
    // The additional localStorage call is to get around a FF quirk, see
    // bug #495747 in bugzilla
    try {
      return 'localStorage' in window && window['localStorage'] !== null &&
          localStorage;
    } catch (e) {
      return false;
    }
  })();

  function Settings(fingerprint) {
    this.fingerprint = fingerprint;
    this.initializedPromise = new PDFJS.Promise();

    var resolvePromise = (function settingsResolvePromise(db) {
      this.initialize(db || '{}');
      this.initializedPromise.resolve();
    }).bind(this);

//#if B2G
//  asyncStorage.getItem('database', resolvePromise);
//#endif

//#if FIREFOX || MOZCENTRAL
//  resolvePromise(FirefoxCom.requestSync('getDatabase', null));
//#endif

//#if !(FIREFOX || MOZCENTRAL || B2G)
    if (isLocalStorageEnabled)
      resolvePromise(localStorage.getItem('database'));
//#endif
  }

  Settings.prototype = {
    initialize: function settingsInitialize(database) {
      database = JSON.parse(database);
      if (!('files' in database))
        database.files = [];
      if (database.files.length >= SETTINGS_MEMORY)
        database.files.shift();
      var index;
      for (var i = 0, length = database.files.length; i < length; i++) {
        var branch = database.files[i];
        if (branch.fingerprint == this.fingerprint) {
          index = i;
          break;
        }
      }
      if (typeof index != 'number')
        index = database.files.push({fingerprint: this.fingerprint}) - 1;
      this.file = database.files[index];
      this.database = database;
    },

    set: function settingsSet(name, val) {
      if (!this.initializedPromise.isResolved)
        return;

      var file = this.file;
      file[name] = val;
      var database = JSON.stringify(this.database);
//#if !(FIREFOX || MOZCENTRAL)
      if (isLocalStorageEnabled)
        localStorage.setItem('database', database);
//#else
//    FirefoxCom.requestSync('setDatabase', database);
//#endif
    },

    get: function settingsGet(name, defaultValue) {
      if (!this.initializedPromise.isResolved)
        return defaultValue;

      return this.file[name] || defaultValue;
    }
  };

  return Settings;
})();

var cache = new Cache(CACHE_SIZE);
var currentPageNumber = 1;

var PDFFindController = {
  startedTextExtraction: false,

  extractTextPromises: [],

  // If active, find results will be highlighted.
  active: false,

  // Stores the text for each page.
  pageContents: [],

  pageMatches: [],

  // Currently selected match.
  selected: {
    pageIdx: -1,
    matchIdx: -1
  },

  // Where find algorithm currently is in the document.
  offset: {
    pageIdx: null,
    matchIdx: null
  },

  resumePageIdx: null,

  resumeCallback: null,

  state: null,

  dirtyMatch: false,

  findTimeout: null,

  initialize: function() {
    var events = [
      'find',
      'findagain',
      'findhighlightallchange',
      'findcasesensitivitychange'
    ];

    this.handleEvent = this.handleEvent.bind(this);

    for (var i = 0; i < events.length; i++) {
      window.addEventListener(events[i], this.handleEvent);
    }
  },

  calcFindMatch: function(pageIndex) {
    var pageContent = this.pageContents[pageIndex];
    var query = this.state.query;
    var caseSensitive = this.state.caseSensitive;
    var queryLen = query.length;

    if (queryLen === 0) {
      // Do nothing the matches should be wiped out already.
      return;
    }

    if (!caseSensitive) {
      pageContent = pageContent.toLowerCase();
      query = query.toLowerCase();
    }

    var matches = [];

    var matchIdx = -queryLen;
    while (true) {
      matchIdx = pageContent.indexOf(query, matchIdx + queryLen);
      if (matchIdx === -1) {
        break;
      }

      matches.push(matchIdx);
    }
    this.pageMatches[pageIndex] = matches;
    this.updatePage(pageIndex);
    if (this.resumePageIdx === pageIndex) {
      var callback = this.resumeCallback;
      this.resumePageIdx = null;
      this.resumeCallback = null;
      callback();
    }
  },

  extractText: function() {
    if (this.startedTextExtraction) {
      return;
    }
    this.startedTextExtraction = true;

    this.pageContents = [];
    for (var i = 0, ii = PDFView.pdfDocument.numPages; i < ii; i++) {
      this.extractTextPromises.push(new PDFJS.Promise());
    }

    var self = this;
    function extractPageText(pageIndex) {
      PDFView.pages[pageIndex].getTextContent().then(
        function textContentResolved(data) {
          // Build the find string.
          var bidiTexts = data.bidiTexts;
          var str = '';

          for (var i = 0; i < bidiTexts.length; i++) {
            str += bidiTexts[i].str;
          }

          // Store the pageContent as a string.
          self.pageContents.push(str);

          self.extractTextPromises[pageIndex].resolve(pageIndex);
          if ((pageIndex + 1) < PDFView.pages.length)
            extractPageText(pageIndex + 1);
        }
      );
    }
    extractPageText(0);
    return this.extractTextPromise;
  },

  handleEvent: function(e) {
    if (this.state === null || e.type !== 'findagain') {
      this.dirtyMatch = true;
    }
    this.state = e.detail;
    this.updateUIState(FindStates.FIND_PENDING);

    this.extractText();

    clearTimeout(this.findTimeout);
    if (e.type === 'find') {
      // Only trigger the find action after 250ms of silence.
      this.findTimeout = setTimeout(this.nextMatch.bind(this), 250);
    } else {
      this.nextMatch();
    }
  },

  updatePage: function(idx) {
    var page = PDFView.pages[idx];

    if (this.selected.pageIdx === idx) {
      // If the page is selected, scroll the page into view, which triggers
      // rendering the page, which adds the textLayer. Once the textLayer is
      // build, it will scroll onto the selected match.
      page.scrollIntoView();
    }

    if (page.textLayer) {
      page.textLayer.updateMatches();
    }
  },

  nextMatch: function() {
    var pages = PDFView.pages;
    var previous = this.state.findPrevious;
    var numPages = PDFView.pages.length;

    this.active = true;

    if (this.dirtyMatch) {
      // Need to recalculate the matches, reset everything.
      this.dirtyMatch = false;
      this.selected.pageIdx = this.selected.matchIdx = -1;
      this.offset.pageIdx = previous ? numPages - 1 : 0;
      this.offset.matchIdx = null;
      this.hadMatch = false;
      this.resumeCallback = null;
      this.resumePageIdx = null;
      this.pageMatches = [];
      var self = this;

      for (var i = 0; i < numPages; i++) {
        // Wipe out any previous highlighted matches.
        this.updatePage(i);

        // As soon as the text is extracted start finding the matches.
        this.extractTextPromises[i].onData(function(pageIdx) {
          // Use a timeout since all the pages may already be extracted and we
          // want to start highlighting before finding all the matches.
          setTimeout(function() {
            self.calcFindMatch(pageIdx);
          });
        });
      }
    }

    // If there's no query there's no point in searching.
    if (this.state.query === '') {
      this.updateUIState(FindStates.FIND_FOUND);
      return;
    }

    // If we're waiting on a page, we return since we can't do anything else.
    if (this.resumeCallback) {
      return;
    }

    var offset = this.offset;
    // If there's already a matchIdx that means we are iterating through a
    // page's matches.
    if (offset.matchIdx !== null) {
      var numPageMatches = this.pageMatches[offset.pageIdx].length;
      if ((!previous && offset.matchIdx + 1 < numPageMatches) ||
          (previous && offset.matchIdx > 0)) {
        // The simple case, we just have advance the matchIdx to select the next
        // match on the page.
        this.hadMatch = true;
        offset.matchIdx = previous ? offset.matchIdx - 1 : offset.matchIdx + 1;
        this.updateMatch(true);
        return;
      }
      // We went beyond the current page's matches, so we advance to the next
      // page.
      this.advanceOffsetPage(previous);
    }
    // Start searching through the page.
    this.nextPageMatch();
  },

  nextPageMatch: function() {
    if (this.resumePageIdx !== null)
      console.error('There can only be one pending page.');

    var matchesReady = function(matches) {
      var offset = this.offset;
      var numMatches = matches.length;
      var previous = this.state.findPrevious;
      if (numMatches) {
        // There were matches for the page, so initialize the matchIdx.
        this.hadMatch = true;
        offset.matchIdx = previous ? numMatches - 1 : 0;
        this.updateMatch(true);
      } else {
        // No matches attempt to search the next page.
        this.advanceOffsetPage(previous);
        if (offset.wrapped) {
          offset.matchIdx = null;
          if (!this.hadMatch) {
            // No point in wrapping there were no matches.
            this.updateMatch(false);
            return;
          }
        }
        // Search the next page.
        this.nextPageMatch();
      }
    }.bind(this);

    var pageIdx = this.offset.pageIdx;
    var pageMatches = this.pageMatches;
    if (!pageMatches[pageIdx]) {
      // The matches aren't ready setup a callback so we can be notified,
      // when they are ready.
      this.resumeCallback = function() {
        matchesReady(pageMatches[pageIdx]);
      };
      this.resumePageIdx = pageIdx;
      return;
    }
    // The matches are finished already.
    matchesReady(pageMatches[pageIdx]);
  },

  advanceOffsetPage: function(previous) {
    var offset = this.offset;
    var numPages = this.extractTextPromises.length;
    offset.pageIdx = previous ? offset.pageIdx - 1 : offset.pageIdx + 1;
    offset.matchIdx = null;
    if (offset.pageIdx >= numPages || offset.pageIdx < 0) {
      offset.pageIdx = previous ? numPages - 1 : 0;
      offset.wrapped = true;
      return;
    }
  },

  updateMatch: function(found) {
    var state = FindStates.FIND_NOTFOUND;
    var wrapped = this.offset.wrapped;
    this.offset.wrapped = false;
    if (found) {
      var previousPage = this.selected.pageIdx;
      this.selected.pageIdx = this.offset.pageIdx;
      this.selected.matchIdx = this.offset.matchIdx;
      state = wrapped ? FindStates.FIND_WRAPPED : FindStates.FIND_FOUND;
      // Update the currently selected page to wipe out any selected matches.
      if (previousPage !== -1 && previousPage !== this.selected.pageIdx) {
        this.updatePage(previousPage);
      }
    }
    this.updateUIState(state, this.state.findPrevious);
    if (this.selected.pageIdx !== -1) {
      this.updatePage(this.selected.pageIdx, true);
    }
  },

  updateUIState: function(state, previous) {
    if (PDFView.supportsIntegratedFind) {
      FirefoxCom.request('updateFindControlState',
                         {result: state, findPrevious: previous});
      return;
    }
    PDFFindBar.updateUIState(state, previous);
  }
};

//var PDFFindBar = {
//  // TODO: Enable the FindBar *AFTER* the pagesPromise in the load function
//  // got resolved
//
//  opened: false,
//
//  initialize: function() {
//    this.bar = document.getElementById('findbar');
//    this.toggleButton = document.getElementById('viewFind');
//    this.findField = document.getElementById('findInput');
//    this.highlightAll = document.getElementById('findHighlightAll');
//    this.caseSensitive = document.getElementById('findMatchCase');
//    this.findMsg = document.getElementById('findMsg');
//    this.findStatusIcon = document.getElementById('findStatusIcon');
//
//    var self = this;
//    this.toggleButton.addEventListener('click', function() {
//      self.toggle();
//    });
//
////    this.findField.addEventListener('input', function() {
////      self.dispatchEvent('');
////    });
//
////    this.bar.addEventListener('keydown', function(evt) {
////      switch (evt.keyCode) {
////        case 13: // Enter
////          if (evt.target === self.findField) {
////            self.dispatchEvent('again', evt.shiftKey);
////          }
////          break;
////        case 27: // Escape
////          self.close();
////          break;
////      }
////    });
//
////    document.getElementById('findPrevious').addEventListener('click',
////      function() { self.dispatchEvent('again', true); }
////    );
////
////    document.getElementById('findNext').addEventListener('click', function() {
////      self.dispatchEvent('again', false);
////    });
////
////    this.highlightAll.addEventListener('click', function() {
////      self.dispatchEvent('highlightallchange');
////    });
////
////    this.caseSensitive.addEventListener('click', function() {
////      self.dispatchEvent('casesensitivitychange');
////    });
//  },
//
//  dispatchEvent: function(aType, aFindPrevious) {
//    var event = document.createEvent('CustomEvent');
//    event.initCustomEvent('find' + aType, true, true, {
//      query: this.findField.value,
//      caseSensitive: this.caseSensitive.checked,
//      highlightAll: this.highlightAll.checked,
//      findPrevious: aFindPrevious
//    });
//    return window.dispatchEvent(event);
//  },
//
//  updateUIState: function(state, previous) {
//    var notFound = false;
//    var findMsg = '';
//    var status = '';
//
//    switch (state) {
//      case FindStates.FIND_FOUND:
//        break;
//
//      case FindStates.FIND_PENDING:
//        status = 'pending';
//        break;
//
//      case FindStates.FIND_NOTFOUND:
//        findMsg = mozL10n.get('find_not_found', null, 'Phrase not found');
//        notFound = true;
//        break;
//
//      case FindStates.FIND_WRAPPED:
//        if (previous) {
//          findMsg = mozL10n.get('find_reached_top', null,
//                      'Reached top of document, continued from bottom');
//        } else {
//          findMsg = mozL10n.get('find_reached_bottom', null,
//                                'Reached end of document, continued from top');
//        }
//        break;
//    }
//
//    if (notFound) {
//      this.findField.classList.add('notFound');
//    } else {
//      this.findField.classList.remove('notFound');
//    }
//
//    this.findField.setAttribute('data-status', status);
//    this.findMsg.textContent = findMsg;
//  },
//
//  open: function() {
//    if (this.opened) return;
//
//    this.opened = true;
//    this.toggleButton.classList.add('toggled');
//    this.bar.classList.remove('hidden');
//    this.findField.select();
//    this.findField.focus();
//  },
//
//  close: function() {
//    if (!this.opened) return;
//
//    this.opened = false;
//    this.toggleButton.classList.remove('toggled');
//    this.bar.classList.add('hidden');
//
//    PDFFindController.active = false;
//  },
//
//  toggle: function() {
//    if (this.opened) {
//      this.close();
//    } else {
//      this.open();
//    }
//  }
//};

var PDFView = {
  pages: [],
  thumbnails: [],
  currentScale: UNKNOWN_SCALE,
  currentScaleValue: null,
  initialBookmark: document.location.hash.substring(1),
  startedTextExtraction: false,
  pageText: [],
  container: null,
  thumbnailContainer: null,
  initialized: false,
  fellback: false,
  pdfDocument: null,
  sidebarOpen: false,
  pageViewScroll: null,
  thumbnailViewScroll: null,
  isFullscreen: false,
  previousScale: null,
  pageRotation: 0,
  mouseScrollTimeStamp: 0,
  mouseScrollDelta: 0,
  lastScroll: 0,
  previousPageNumber: 1,

  // called once when the document is loaded
  initialize: function pdfViewInitialize() {
    var self = this;
    var container = this.container = document.getElementById('viewerContainer');
    this.pageViewScroll = {};
    this.watchScroll(container, this.pageViewScroll, updateViewarea);

    var thumbnailContainer = this.thumbnailContainer =
                             document.getElementById('thumbnailView');
    this.thumbnailViewScroll = {};
    this.watchScroll(thumbnailContainer, this.thumbnailViewScroll,
                     this.renderHighestPriority.bind(this));
//
//    PDFFindBar.initialize();
//    PDFFindController.initialize();

    this.initialized = true;
    container.addEventListener('scroll', function() {
      self.lastScroll = Date.now();
    }, false);
  },

  // Helper function to keep track whether a div was scrolled up or down and
  // then call a callback.
  watchScroll: function pdfViewWatchScroll(viewAreaElement, state, callback) {
    state.down = true;
    state.lastY = viewAreaElement.scrollTop;
    viewAreaElement.addEventListener('scroll', function webViewerScroll(evt) {
      var currentY = viewAreaElement.scrollTop;
      var lastY = state.lastY;
      if (currentY > lastY)
        state.down = true;
      else if (currentY < lastY)
        state.down = false;
      // else do nothing and use previous value
      state.lastY = currentY;
      callback();
    }, true);
  },

  setScale: function pdfViewSetScale(val, resetAutoSettings, noScroll) {
    if (val == this.currentScale)
      return;

    var pages = this.pages;
    for (var i = 0; i < pages.length; i++)
      pages[i].update(val * CSS_UNITS);

    if (!noScroll && this.currentScale != val)
      this.pages[this.page - 1].scrollIntoView();
    this.currentScale = val;

    var event = document.createEvent('UIEvents');
    event.initUIEvent('scalechange', false, false, window, 0);
    event.scale = val;
    event.resetAutoSettings = resetAutoSettings;
    window.dispatchEvent(event);
  },

  parseScale: function pdfViewParseScale(value, resetAutoSettings, noScroll) {
    if ('custom' == value)
      return;

    var scale = parseFloat(value);
    this.currentScaleValue = value;
    if (scale) {
      this.setScale(scale, true, noScroll);
      return;
    }

    var container = this.container;
    var currentPage = this.pages[this.page - 1];
    if (!currentPage) {
      return;
    }

    var pageWidthScale = (container.clientWidth - SCROLLBAR_PADDING) /
                          currentPage.width * currentPage.scale / CSS_UNITS;
    var pageHeightScale = (container.clientHeight - VERTICAL_PADDING) /
                           currentPage.height * currentPage.scale / CSS_UNITS;
    switch (value) {
      case 'page-actual':
        scale = 1;
        break;
      case 'page-width':
        scale = pageWidthScale;
        break;
      case 'page-height':
        scale = pageHeightScale;
        break;
      case 'page-fit':
        scale = Math.min(pageWidthScale, pageHeightScale);
        break;
      case 'auto':
        scale = Math.min(1.0, pageWidthScale);
        break;
    }
    this.setScale(scale, resetAutoSettings, noScroll);

    selectScaleOption(value);
  },

  zoomIn: function pdfViewZoomIn() {
    var newScale = (this.currentScale * DEFAULT_SCALE_DELTA).toFixed(2);
    newScale = Math.min(MAX_SCALE, newScale);
    this.parseScale(newScale, true);
  },

  zoomOut: function pdfViewZoomOut() {
    var newScale = (this.currentScale / DEFAULT_SCALE_DELTA).toFixed(2);
    newScale = Math.max(MIN_SCALE, newScale);
    this.parseScale(newScale, true);
  },

  set page(val) {
    var pages = this.pages;
    var input = document.getElementById('pageNumber');
    var event = document.createEvent('UIEvents');
    event.initUIEvent('pagechange', false, false, window, 0);

    if (!(0 < val && val <= pages.length)) {
      this.previousPageNumber = val;
      event.pageNumber = this.page;
      window.dispatchEvent(event);
      return;
    }

    pages[val - 1].updateStats();
    this.previousPageNumber = currentPageNumber;
    currentPageNumber = val;
    event.pageNumber = val;
    window.dispatchEvent(event);

    // checking if the this.page was called from the updateViewarea function:
    // avoiding the creation of two "set page" method (internal and public)
    if (updateViewarea.inProgress)
      return;

    // Avoid scrolling the first page during loading
    if (this.loading && val == 1)
      return;

    pages[val - 1].scrollIntoView();
  },

  get page() {
    return currentPageNumber;
  },

  get supportsPrinting() {
    var canvas = document.createElement('canvas');
    var value = 'mozPrintCallback' in canvas;
    // shadow
    Object.defineProperty(this, 'supportsPrinting', { value: value,
                                                      enumerable: true,
                                                      configurable: true,
                                                      writable: false });
    return value;
  },

  get supportsFullscreen() {
    var doc = document.documentElement;
    var support = doc.requestFullscreen || doc.mozRequestFullScreen ||
                  doc.webkitRequestFullScreen;

    // Disable fullscreen button if we're in an iframe
    if (!!window.frameElement)
      support = false;

    Object.defineProperty(this, 'supportsFullScreen', { value: support,
                                                        enumerable: true,
                                                        configurable: true,
                                                        writable: false });
    return support;
  },

  get supportsIntegratedFind() {
    var support = false;
//#if !(FIREFOX || MOZCENTRAL)
//#else
//  support = FirefoxCom.requestSync('supportsIntegratedFind');
//#endif
    Object.defineProperty(this, 'supportsIntegratedFind', { value: support,
                                                            enumerable: true,
                                                            configurable: true,
                                                            writable: false });
    return support;
  },

  get supportsDocumentFonts() {
    var support = true;
//#if !(FIREFOX || MOZCENTRAL)
//#else
//  support = FirefoxCom.requestSync('supportsDocumentFonts');
//#endif
    Object.defineProperty(this, 'supportsDocumentFonts', { value: support,
                                                           enumerable: true,
                                                           configurable: true,
                                                           writable: false });
    return support;
  },

  get isHorizontalScrollbarEnabled() {
    var div = document.getElementById('viewerContainer');
    return div.scrollWidth > div.clientWidth;
  },

  initPassiveLoading: function pdfViewInitPassiveLoading() {
    if (!PDFView.loadingBar) {
      PDFView.loadingBar = new ProgressBar('#loadingBar', {});
    }

    window.addEventListener('message', function window_message(e) {
      var args = e.data;

      if (typeof args !== 'object' || !('pdfjsLoadAction' in args))
        return;
      switch (args.pdfjsLoadAction) {
        case 'progress':
          PDFView.progress(args.loaded / args.total);
          break;
        case 'complete':
          if (!args.data) {
            PDFView.error(mozL10n.get('loading_error', null,
                          'An error occurred while loading the PDF.'), e);
            break;
          }
          PDFView.open(args.data, 0);
          break;
      }
    });
    FirefoxCom.requestSync('initPassiveLoading', null);
  },

  setTitleUsingUrl: function pdfViewSetTitleUsingUrl(url) {
    this.url = url;
    try {
      this.setTitle(decodeURIComponent(getFileName(url)) || url);
    } catch (e) {
      // decodeURIComponent may throw URIError,
      // fall back to using the unprocessed url in that case
      this.setTitle(url);
    }
  },

  setTitle: function pdfViewSetTitle(title) {
    document.title = title;
//#if B2G
//  document.getElementById('activityTitle').textContent = title;
//#endif
  },

  open: function pdfViewOpen(url, scale, password) {
    var parameters = {password: password};
    if (typeof url === 'string') { // URL
      this.setTitleUsingUrl(url);
      parameters.url = url;
    } else if (url && 'byteLength' in url) { // ArrayBuffer
      parameters.data = url;
    }

    if (!PDFView.loadingBar) {
      PDFView.loadingBar = new ProgressBar('#loadingBar', {});
    }

    this.pdfDocument = null;
    var self = this;
    self.loading = true;
    PDFJS.getDocument(parameters).then(
      function getDocumentCallback(pdfDocument) {
        self.load(pdfDocument, scale);
        self.loading = false;
      },
      function getDocumentError(message, exception) {
        if (exception && exception.name === 'PasswordException') {
          if (exception.code === 'needpassword') {
            var promptString = mozL10n.get('request_password', null,
                                      'PDF is protected by a password:');
            password = prompt(promptString);
            if (password && password.length > 0) {
              return PDFView.open(url, scale, password);
            }
          }
        }

        var loadingErrorMessage = mozL10n.get('loading_error', null,
          'An error occurred while loading the PDF.');

        if (exception && exception.name === 'InvalidPDFException') {
          // change error message also for other builds
          var loadingErrorMessage = mozL10n.get('invalid_file_error', null,
                                        'Invalid or corrupted PDF file.');
//#if B2G
//        window.alert(loadingErrorMessage);
//        return window.close();
//#endif
        }

        if (exception && exception.name === 'MissingPDFException') {
          // special message for missing PDF's
          var loadingErrorMessage = mozL10n.get('missing_file_error', null,
                                        'Missing PDF file.');

//#if B2G
//        window.alert(loadingErrorMessage);
//        return window.close();
//#endif
        }

        var loadingIndicator = document.getElementById('loading');
        loadingIndicator.textContent = mozL10n.get('loading_error_indicator',
          null, 'Error');
        var moreInfo = {
          message: message
        };
        self.error(loadingErrorMessage, moreInfo);
        self.loading = false;
      },
      function getDocumentProgress(progressData) {
        self.progress(progressData.loaded / progressData.total);
      }
    );
  },

  download: function pdfViewDownload() {
    function noData() {
      FirefoxCom.request('download', { originalUrl: url });
    }
    var url = this.url.split('#')[0];
//#if !(FIREFOX || MOZCENTRAL)
    url += '#pdfjs.action=download';
    window.open(url, '_parent');
//#else
//  // Document isn't ready just try to download with the url.
//  if (!this.pdfDocument) {
//    noData();
//    return;
//  }
//  this.pdfDocument.getData().then(
//    function getDataSuccess(data) {
//      var blob = PDFJS.createBlob(data.buffer, 'application/pdf');
//      var blobUrl = window.URL.createObjectURL(blob);
//
//      FirefoxCom.request('download', { blobUrl: blobUrl, originalUrl: url },
//        function response(err) {
//          if (err) {
//            // This error won't really be helpful because it's likely the
//            // fallback won't work either (or is already open).
//            PDFView.error('PDF failed to download.');
//          }
//          window.URL.revokeObjectURL(blobUrl);
//        }
//      );
//    },
//    noData // Error occurred try downloading with just the url.
//  );
//#endif
  },

  fallback: function pdfViewFallback() {
//#if !(FIREFOX || MOZCENTRAL)
//  return;
//#else
//  // Only trigger the fallback once so we don't spam the user with messages
//  // for one PDF.
//  if (this.fellback)
//    return;
//  this.fellback = true;
//  var url = this.url.split('#')[0];
//  FirefoxCom.request('fallback', url, function response(download) {
//    if (!download)
//      return;
//    PDFView.download();
//  });
//#endif
  },

  navigateTo: function pdfViewNavigateTo(dest) {
    if (typeof dest === 'string')
      dest = this.destinations[dest];
    if (!(dest instanceof Array))
      return; // invalid destination
    // dest array looks like that: <page-ref> </XYZ|FitXXX> <args..>
    var destRef = dest[0];
    var pageNumber = destRef instanceof Object ?
      this.pagesRefMap[destRef.num + ' ' + destRef.gen + ' R'] : (destRef + 1);
    if (pageNumber > this.pages.length)
      pageNumber = this.pages.length;
    if (pageNumber) {
      this.page = pageNumber;
      var currentPage = this.pages[pageNumber - 1];
      currentPage.scrollIntoView(dest);
    }
  },

  getDestinationHash: function pdfViewGetDestinationHash(dest) {
    if (typeof dest === 'string')
      return PDFView.getAnchorUrl('#' + escape(dest));
    if (dest instanceof Array) {
      var destRef = dest[0]; // see navigateTo method for dest format
      var pageNumber = destRef instanceof Object ?
        this.pagesRefMap[destRef.num + ' ' + destRef.gen + ' R'] :
        (destRef + 1);
      if (pageNumber) {
        var pdfOpenParams = PDFView.getAnchorUrl('#page=' + pageNumber);
        var destKind = dest[1];
        if (typeof destKind === 'object' && 'name' in destKind &&
            destKind.name == 'XYZ') {
          var scale = (dest[4] || this.currentScale);
          pdfOpenParams += '&zoom=' + (scale * 100);
          if (dest[2] || dest[3]) {
            pdfOpenParams += ',' + (dest[2] || 0) + ',' + (dest[3] || 0);
          }
        }
        return pdfOpenParams;
      }
    }
    return '';
  },

  /**
   * For the firefox extension we prefix the full url on anchor links so they
   * don't come up as resource:// urls and so open in new tab/window works.
   * @param {String} anchor The anchor hash include the #.
   */
  getAnchorUrl: function getAnchorUrl(anchor) {
//#if !(FIREFOX || MOZCENTRAL)
    return anchor;
//#else
//  return this.url.split('#')[0] + anchor;
//#endif
  },

  /**
   * Returns scale factor for the canvas. It makes sense for the HiDPI displays.
   * @return {Object} The object with horizontal (sx) and vertical (sy)
                      scales. The scaled property is set to false if scaling is
                      not required, true otherwise.
   */
  getOutputScale: function pdfViewGetOutputDPI() {
    var pixelRatio = 'devicePixelRatio' in window ? window.devicePixelRatio : 1;
    return {
      sx: pixelRatio,
      sy: pixelRatio,
      scaled: pixelRatio != 1
    };
  },

  /**
   * Show the error box.
   * @param {String} message A message that is human readable.
   * @param {Object} moreInfo (optional) Further information about the error
   *                            that is more technical.  Should have a 'message'
   *                            and optionally a 'stack' property.
   */
  error: function pdfViewError(message, moreInfo) {
    var moreInfoText = mozL10n.get('error_version_info',
      {version: PDFJS.version || '?', build: PDFJS.build || '?'},
      'PDF.js v{{version}} (build: {{build}})') + '\n';
    if (moreInfo) {
      moreInfoText +=
        mozL10n.get('error_message', {message: moreInfo.message},
        'Message: {{message}}');
      if (moreInfo.stack) {
        moreInfoText += '\n' +
          mozL10n.get('error_stack', {stack: moreInfo.stack},
          'Stack: {{stack}}');
      } else {
        if (moreInfo.filename) {
          moreInfoText += '\n' +
            mozL10n.get('error_file', {file: moreInfo.filename},
            'File: {{file}}');
        }
        if (moreInfo.lineNumber) {
          moreInfoText += '\n' +
            mozL10n.get('error_line', {line: moreInfo.lineNumber},
            'Line: {{line}}');
        }
      }
    }

    var loadingBox = document.getElementById('loadingBox');
    loadingBox.setAttribute('hidden', 'true');

//#if !(FIREFOX || MOZCENTRAL)
    var errorWrapper = document.getElementById('errorWrapper');
    errorWrapper.removeAttribute('hidden');

    var errorMessage = document.getElementById('errorMessage');
    errorMessage.textContent = message;

    var closeButton = document.getElementById('errorClose');
    closeButton.onclick = function() {
      errorWrapper.setAttribute('hidden', 'true');
    };

    var errorMoreInfo = document.getElementById('errorMoreInfo');
    var moreInfoButton = document.getElementById('errorShowMore');
    var lessInfoButton = document.getElementById('errorShowLess');
    moreInfoButton.onclick = function() {
      errorMoreInfo.removeAttribute('hidden');
      moreInfoButton.setAttribute('hidden', 'true');
      lessInfoButton.removeAttribute('hidden');
    };
    lessInfoButton.onclick = function() {
      errorMoreInfo.setAttribute('hidden', 'true');
      moreInfoButton.removeAttribute('hidden');
      lessInfoButton.setAttribute('hidden', 'true');
    };
    moreInfoButton.removeAttribute('hidden');
    lessInfoButton.setAttribute('hidden', 'true');
    errorMoreInfo.value = moreInfoText;

    errorMoreInfo.rows = moreInfoText.split('\n').length - 1;
//#else
//  console.error(message + '\n' + moreInfoText);
//  this.fallback();
//#endif
  },

  progress: function pdfViewProgress(level) {
    var percent = Math.round(level * 100);
    PDFView.loadingBar.percent = percent;
  },

  load: function pdfViewLoad(pdfDocument, scale) {
    function bindOnAfterDraw(pageView, thumbnailView) {
      // when page is painted, using the image as thumbnail base
      pageView.onAfterDraw = function pdfViewLoadOnAfterDraw() {
        thumbnailView.setImage(pageView.canvas);
      };
    }

    this.pdfDocument = pdfDocument;

    var errorWrapper = document.getElementById('errorWrapper');
    errorWrapper.setAttribute('hidden', 'true');

    var loadingBox = document.getElementById('loadingBox');
    loadingBox.setAttribute('hidden', 'true');
    var loadingIndicator = document.getElementById('loading');
    loadingIndicator.textContent = '';

    var thumbsView = document.getElementById('thumbnailView');
    thumbsView.parentNode.scrollTop = 0;

    while (thumbsView.hasChildNodes())
      thumbsView.removeChild(thumbsView.lastChild);

    if ('_loadingInterval' in thumbsView)
      clearInterval(thumbsView._loadingInterval);

    var container = document.getElementById('viewer');
    while (container.hasChildNodes())
      container.removeChild(container.lastChild);

    var pagesCount = pdfDocument.numPages;
    var id = pdfDocument.fingerprint;
    document.getElementById('numPages').textContent =
      mozL10n.get('page_of', {pageCount: pagesCount}, 'of {{pageCount}}');
    document.getElementById('pageNumber').max = pagesCount;

    PDFView.documentFingerprint = id;
    var store = PDFView.store = new Settings(id);
    var storePromise = store.initializedPromise;

    this.pageRotation = 0;

    var pages = this.pages = [];
    this.pageText = [];
    this.startedTextExtraction = false;
    var pagesRefMap = {};
    var thumbnails = this.thumbnails = [];
    var pagePromises = [];
    for (var i = 1; i <= pagesCount; i++)
      pagePromises.push(pdfDocument.getPage(i));
    var self = this;
    var pagesPromise = PDFJS.Promise.all(pagePromises);
    pagesPromise.then(function(promisedPages) {
      for (var i = 1; i <= pagesCount; i++) {
        var page = promisedPages[i - 1];
        var pageView = new PageView(container, page, i, scale,
                                    page.stats, self.navigateTo.bind(self));
        var thumbnailView = new ThumbnailView(thumbsView, page, i);
        bindOnAfterDraw(pageView, thumbnailView);

        pages.push(pageView);
        thumbnails.push(thumbnailView);
        var pageRef = page.ref;
        pagesRefMap[pageRef.num + ' ' + pageRef.gen + ' R'] = i;
      }

      self.pagesRefMap = pagesRefMap;
    });

    var destinationsPromise = pdfDocument.getDestinations();
    destinationsPromise.then(function(destinations) {
      self.destinations = destinations;
    });

    // outline and initial view depends on destinations and pagesRefMap
    var promises = [pagesPromise, destinationsPromise, storePromise,
                    PDFView.animationStartedPromise];
    PDFJS.Promise.all(promises).then(function() {
      pdfDocument.getOutline().then(function(outline) {
        self.outline = new DocumentOutlineView(outline);
      });

      var storedHash = null;
      if (store.get('exists', false)) {
        var page = store.get('page', '1');
        var zoom = store.get('zoom', PDFView.currentScale);
        var left = store.get('scrollLeft', '0');
        var top = store.get('scrollTop', '0');

        storedHash = 'page=' + page + '&zoom=' + zoom + ',' + left + ',' + top;
      }

      self.setInitialView(storedHash, scale);
    });

    pdfDocument.getMetadata().then(function(data) {
      var info = data.info, metadata = data.metadata;
      self.documentInfo = info;
      self.metadata = metadata;

      // Provides some basic debug information
      console.log('PDF ' + pdfDocument.fingerprint + ' [' +
                  info.PDFFormatVersion + ' ' + (info.Producer || '-') +
                  ' / ' + (info.Creator || '-') + ']' +
                  (PDFJS.version ? ' (PDF.js: ' + PDFJS.version + ')' : ''));

      var pdfTitle;
      if (metadata) {
        if (metadata.has('dc:title'))
          pdfTitle = metadata.get('dc:title');
      }

      if (!pdfTitle && info && info['Title'])
        pdfTitle = info['Title'];

      if (pdfTitle)
        self.setTitle(pdfTitle + ' - ' + document.title);

      if (info.IsAcroFormPresent) {
        // AcroForm/XFA was found
        PDFView.fallback();
      }
    });
  },

  setInitialView: function pdfViewSetInitialView(storedHash, scale) {
    // Reset the current scale, as otherwise the page's scale might not get
    // updated if the zoom level stayed the same.
    this.currentScale = 0;
    this.currentScaleValue = null;
    if (this.initialBookmark) {
      this.setHash(this.initialBookmark);
      this.initialBookmark = null;
    }
    else if (storedHash)
      this.setHash(storedHash);
    else if (scale) {
      this.parseScale(scale, true);
      this.page = 1;
    }

    if (PDFView.currentScale === UNKNOWN_SCALE) {
      // Scale was not initialized: invalid bookmark or scale was not specified.
      // Setting the default one.
      this.parseScale(DEFAULT_SCALE, true);
    }
  },

  renderHighestPriority: function pdfViewRenderHighestPriority() {
    // Pages have a higher priority than thumbnails, so check them first.
    var visiblePages = this.getVisiblePages();
    var pageView = this.getHighestPriority(visiblePages, this.pages,
                                           this.pageViewScroll.down);
    if (pageView) {
      this.renderView(pageView, 'page');
      return;
    }
    // No pages needed rendering so check thumbnails.
    if (this.sidebarOpen) {
      var visibleThumbs = this.getVisibleThumbs();
      var thumbView = this.getHighestPriority(visibleThumbs,
                                              this.thumbnails,
                                              this.thumbnailViewScroll.down);
      if (thumbView)
        this.renderView(thumbView, 'thumbnail');
    }
  },

  getHighestPriority: function pdfViewGetHighestPriority(visible, views,
                                                         scrolledDown) {
    // The state has changed figure out which page has the highest priority to
    // render next (if any).
    // Priority:
    // 1 visible pages
    // 2 if last scrolled down page after the visible pages
    // 2 if last scrolled up page before the visible pages
    var visibleViews = visible.views;

    var numVisible = visibleViews.length;
    if (numVisible === 0) {
      return false;
    }
    for (var i = 0; i < numVisible; ++i) {
      var view = visibleViews[i].view;
      if (!this.isViewFinished(view))
        return view;
    }

    // All the visible views have rendered, try to render next/previous pages.
    if (scrolledDown) {
      var nextPageIndex = visible.last.id;
      // ID's start at 1 so no need to add 1.
      if (views[nextPageIndex] && !this.isViewFinished(views[nextPageIndex]))
        return views[nextPageIndex];
    } else {
      var previousPageIndex = visible.first.id - 2;
      if (views[previousPageIndex] &&
          !this.isViewFinished(views[previousPageIndex]))
        return views[previousPageIndex];
    }
    // Everything that needs to be rendered has been.
    return false;
  },

  isViewFinished: function pdfViewNeedsRendering(view) {
    return view.renderingState === RenderingStates.FINISHED;
  },

  // Render a page or thumbnail view. This calls the appropriate function based
  // on the views state. If the view is already rendered it will return false.
  renderView: function pdfViewRender(view, type) {
    var state = view.renderingState;
    switch (state) {
      case RenderingStates.FINISHED:
        return false;
      case RenderingStates.PAUSED:
        PDFView.highestPriorityPage = type + view.id;
        view.resume();
        break;
      case RenderingStates.RUNNING:
        PDFView.highestPriorityPage = type + view.id;
        break;
      case RenderingStates.INITIAL:
        PDFView.highestPriorityPage = type + view.id;
        view.draw(this.renderHighestPriority.bind(this));
        break;
    }
    return true;
  },

  setHash: function pdfViewSetHash(hash) {
    if (!hash)
      return;

    if (hash.indexOf('=') >= 0) {
      var params = PDFView.parseQueryString(hash);
      // borrowing syntax from "Parameters for Opening PDF Files"
      if ('nameddest' in params) {
        PDFView.navigateTo(params.nameddest);
        return;
      }
      if ('page' in params) {
        var pageNumber = (params.page | 0) || 1;
        if ('zoom' in params) {
          var zoomArgs = params.zoom.split(','); // scale,left,top
          // building destination array

          // If the zoom value, it has to get divided by 100. If it is a string,
          // it should stay as it is.
          var zoomArg = zoomArgs[0];
          var zoomArgNumber = parseFloat(zoomArg);
          if (zoomArgNumber)
            zoomArg = zoomArgNumber / 100;

          var dest = [null, {name: 'XYZ'}, (zoomArgs[1] | 0),
            (zoomArgs[2] | 0), zoomArg];
          var currentPage = this.pages[pageNumber - 1];
          currentPage.scrollIntoView(dest);
        } else {
          this.page = pageNumber; // simple page
        }
      }
    } else if (/^\d+$/.test(hash)) // page number
      this.page = hash;
    else // named destination
      PDFView.navigateTo(unescape(hash));
  },

  switchSidebarView: function pdfViewSwitchSidebarView(view) {
    var thumbsView = document.getElementById('thumbnailView');
    var outlineView = document.getElementById('outlineView');

    var thumbsButton = document.getElementById('viewThumbnail');
    var outlineButton = document.getElementById('viewOutline');

    switch (view) {
      case 'thumbs':
        var wasOutlineViewVisible = thumbsView.classList.contains('hidden');

        thumbsButton.classList.add('toggled');
        outlineButton.classList.remove('toggled');
        thumbsView.classList.remove('hidden');
        outlineView.classList.add('hidden');

        PDFView.renderHighestPriority();

        if (wasOutlineViewVisible) {
          // Ensure that the thumbnail of the current page is visible
          // when switching from the outline view.
          scrollIntoView(document.getElementById('thumbnailContainer' +
                                                 this.page));
        }
        break;

      case 'outline':
        thumbsButton.classList.remove('toggled');
        outlineButton.classList.add('toggled');
        thumbsView.classList.add('hidden');
        outlineView.classList.remove('hidden');

        if (outlineButton.getAttribute('disabled'))
          return;
        break;
    }
  },

  getVisiblePages: function pdfViewGetVisiblePages() {
    return this.getVisibleElements(this.container,
                                   this.pages, true);
  },

  getVisibleThumbs: function pdfViewGetVisibleThumbs() {
    return this.getVisibleElements(this.thumbnailContainer,
                                   this.thumbnails);
  },

  // Generic helper to find out what elements are visible within a scroll pane.
  getVisibleElements: function pdfViewGetVisibleElements(
      scrollEl, views, sortByVisibility) {
    var currentHeight = 0, view;
    var top = scrollEl.scrollTop;

    for (var i = 1, ii = views.length; i <= ii; ++i) {
      view = views[i - 1];
      currentHeight = view.el.offsetTop;
      if (currentHeight + view.el.clientHeight > top)
        break;
      currentHeight += view.el.clientHeight;
    }

    var visible = [];

    // Algorithm broken in fullscreen mode
    if (this.isFullscreen) {
      var currentPage = this.pages[this.page - 1];
      visible.push({
        id: currentPage.id,
        view: currentPage
      });

      return { first: currentPage, last: currentPage, views: visible};
    }

    var bottom = top + scrollEl.clientHeight;
    var nextHeight, hidden, percent, viewHeight;
    for (; i <= ii && currentHeight < bottom; ++i) {
      view = views[i - 1];
      viewHeight = view.el.clientHeight;
      currentHeight = view.el.offsetTop;
      nextHeight = currentHeight + viewHeight;
      hidden = Math.max(0, top - currentHeight) +
               Math.max(0, nextHeight - bottom);
      percent = Math.floor((viewHeight - hidden) * 100.0 / viewHeight);
      visible.push({ id: view.id, y: currentHeight,
                     view: view, percent: percent });
      currentHeight = nextHeight;
    }

    var first = visible[0];
    var last = visible[visible.length - 1];

    if (sortByVisibility) {
      visible.sort(function(a, b) {
        var pc = a.percent - b.percent;
        if (Math.abs(pc) > 0.001)
          return -pc;

        return a.id - b.id; // ensure stability
      });
    }

    return {first: first, last: last, views: visible};
  },

  // Helper function to parse query string (e.g. ?param1=value&parm2=...).
  parseQueryString: function pdfViewParseQueryString(query) {
    var parts = query.split('&');
    var params = {};
    for (var i = 0, ii = parts.length; i < parts.length; ++i) {
      var param = parts[i].split('=');
      var key = param[0];
      var value = param.length > 1 ? param[1] : null;
      params[unescape(key)] = unescape(value);
    }
    return params;
  },

  beforePrint: function pdfViewSetupBeforePrint() {
    if (!this.supportsPrinting) {
      var printMessage = mozL10n.get('printing_not_supported', null,
          'Warning: Printing is not fully supported by this browser.');
      this.error(printMessage);
      return;
    }
    var body = document.querySelector('body');
    body.setAttribute('data-mozPrintCallback', true);
    for (var i = 0, ii = this.pages.length; i < ii; ++i) {
      this.pages[i].beforePrint();
    }
  },

  afterPrint: function pdfViewSetupAfterPrint() {
    var div = document.getElementById('printContainer');
    while (div.hasChildNodes())
      div.removeChild(div.lastChild);
  },

  fullscreen: function pdfViewFullscreen() {
    var isFullscreen = document.fullscreenElement || document.mozFullScreen ||
        document.webkitIsFullScreen;

    if (isFullscreen) {
      return false;
    }

    var wrapper = document.getElementById('viewerContainer');
    if (document.documentElement.requestFullscreen) {
      wrapper.requestFullscreen();
    } else if (document.documentElement.mozRequestFullScreen) {
      wrapper.mozRequestFullScreen();
    } else if (document.documentElement.webkitRequestFullScreen) {
      wrapper.webkitRequestFullScreen(Element.ALLOW_KEYBOARD_INPUT);
    } else {
      return false;
    }

    this.isFullscreen = true;
    var currentPage = this.pages[this.page - 1];
    this.previousScale = this.currentScaleValue;
    this.parseScale('page-fit', true);

    // Wait for fullscreen to take effect
    setTimeout(function() {
      currentPage.scrollIntoView();
    }, 0);

    this.showPresentationControls();
    return true;
  },

  exitFullscreen: function pdfViewExitFullscreen() {
    this.isFullscreen = false;
    this.parseScale(this.previousScale);
    this.page = this.page;
    this.clearMouseScrollState();
    this.hidePresentationControls();
  },

  showPresentationControls: function pdfViewShowPresentationControls() {
    var DELAY_BEFORE_HIDING_CONTROLS = 3000;
    var wrapper = document.getElementById('viewerContainer');
    if (this.presentationControlsTimeout) {
      clearTimeout(this.presentationControlsTimeout);
    } else {
      wrapper.classList.add('presentationControls');
    }
    this.presentationControlsTimeout = setTimeout(function hideControls() {
      wrapper.classList.remove('presentationControls');
      delete PDFView.presentationControlsTimeout;
    }, DELAY_BEFORE_HIDING_CONTROLS);
  },

  hidePresentationControls: function pdfViewShowPresentationControls() {
    if (!this.presentationControlsTimeout) {
      return;
    }
    clearTimeout(this.presentationControlsTimeout);
    delete this.presentationControlsTimeout;

    var wrapper = document.getElementById('viewerContainer');
    wrapper.classList.remove('presentationControls');
  },

  rotatePages: function pdfViewPageRotation(delta) {

    this.pageRotation = (this.pageRotation + 360 + delta) % 360;

    for (var i = 0, l = this.pages.length; i < l; i++) {
      var page = this.pages[i];
      page.update(page.scale, this.pageRotation);
    }

    for (var i = 0, l = this.thumbnails.length; i < l; i++) {
      var thumb = this.thumbnails[i];
      thumb.updateRotation(this.pageRotation);
    }

    var currentPage = this.pages[this.page - 1];

    this.parseScale(this.currentScaleValue, true);

    this.renderHighestPriority();

    // Wait for fullscreen to take effect
    setTimeout(function() {
      currentPage.scrollIntoView();
    }, 0);
  },

  /**
   * This function flips the page in presentation mode if the user scrolls up
   * or down with large enough motion and prevents page flipping too often.
   *
   * @this {PDFView}
   * @param {number} mouseScrollDelta The delta value from the mouse event.
   */
  mouseScroll: function pdfViewMouseScroll(mouseScrollDelta) {
    var MOUSE_SCROLL_COOLDOWN_TIME = 50;

    var currentTime = (new Date()).getTime();
    var storedTime = this.mouseScrollTimeStamp;

    // In case one page has already been flipped there is a cooldown time
    // which has to expire before next page can be scrolled on to.
    if (currentTime > storedTime &&
        currentTime - storedTime < MOUSE_SCROLL_COOLDOWN_TIME)
      return;

    // In case the user decides to scroll to the opposite direction than before
    // clear the accumulated delta.
    if ((this.mouseScrollDelta > 0 && mouseScrollDelta < 0) ||
        (this.mouseScrollDelta < 0 && mouseScrollDelta > 0))
      this.clearMouseScrollState();

    this.mouseScrollDelta += mouseScrollDelta;

    var PAGE_FLIP_THRESHOLD = 120;
    if (Math.abs(this.mouseScrollDelta) >= PAGE_FLIP_THRESHOLD) {

      var PageFlipDirection = {
        UP: -1,
        DOWN: 1
      };

      // In fullscreen mode scroll one page at a time.
      var pageFlipDirection = (this.mouseScrollDelta > 0) ?
                                PageFlipDirection.UP :
                                PageFlipDirection.DOWN;
      this.clearMouseScrollState();
      var currentPage = this.page;

      // In case we are already on the first or the last page there is no need
      // to do anything.
      if ((currentPage == 1 && pageFlipDirection == PageFlipDirection.UP) ||
          (currentPage == this.pages.length &&
           pageFlipDirection == PageFlipDirection.DOWN))
        return;

      this.page += pageFlipDirection;
      this.mouseScrollTimeStamp = currentTime;
    }
  },

  /**
   * This function clears the member attributes used with mouse scrolling in
   * presentation mode.
   *
   * @this {PDFView}
   */
  clearMouseScrollState: function pdfViewClearMouseScrollState() {
    this.mouseScrollTimeStamp = 0;
    this.mouseScrollDelta = 0;
  }
};

var PageView = function pageView(container, pdfPage, id, scale,
                                 stats, navigateTo) {
  this.id = id;
  this.pdfPage = pdfPage;

  this.rotation = 0;
  this.scale = scale || 1.0;
  this.viewport = this.pdfPage.getViewport(this.scale, this.pdfPage.rotate);

  this.renderingState = RenderingStates.INITIAL;
  this.resume = null;

  this.textContent = null;
  this.textLayer = null;

  var anchor = document.createElement('a');
  anchor.name = '' + this.id;

  var div = this.el = document.createElement('div');
  div.id = 'pageContainer' + this.id;
  div.className = 'page';
  div.style.width = Math.floor(this.viewport.width) + 'px';
  div.style.height = Math.floor(this.viewport.height) + 'px';

  container.appendChild(anchor);
  container.appendChild(div);

  this.destroy = function pageViewDestroy() {
    this.update();
    this.pdfPage.destroy();
  };

  this.update = function pageViewUpdate(scale, rotation) {
    this.renderingState = RenderingStates.INITIAL;
    this.resume = null;

    if (typeof rotation !== 'undefined') {
      this.rotation = rotation;
    }

    this.scale = scale || this.scale;

    var totalRotation = (this.rotation + this.pdfPage.rotate) % 360;
    var viewport = this.pdfPage.getViewport(this.scale, totalRotation);

    this.viewport = viewport;
    div.style.width = Math.floor(viewport.width) + 'px';
    div.style.height = Math.floor(viewport.height) + 'px';

    while (div.hasChildNodes())
      div.removeChild(div.lastChild);
    div.removeAttribute('data-loaded');

    delete this.canvas;

    this.loadingIconDiv = document.createElement('div');
    this.loadingIconDiv.className = 'loadingIcon';
    div.appendChild(this.loadingIconDiv);
  };

  Object.defineProperty(this, 'width', {
    get: function PageView_getWidth() {
      return this.viewport.width;
    },
    enumerable: true
  });

  Object.defineProperty(this, 'height', {
    get: function PageView_getHeight() {
      return this.viewport.height;
    },
    enumerable: true
  });

  function setupAnnotations(pdfPage, viewport) {
    function bindLink(link, dest) {
      link.href = PDFView.getDestinationHash(dest);
      link.onclick = function pageViewSetupLinksOnclick() {
        if (dest)
          PDFView.navigateTo(dest);
        return false;
      };
    }
    function createElementWithStyle(tagName, item, rect) {
      if (!rect) {
        rect = viewport.convertToViewportRectangle(item.rect);
        rect = PDFJS.Util.normalizeRect(rect);
      }
      var element = document.createElement(tagName);
      element.style.left = Math.floor(rect[0]) + 'px';
      element.style.top = Math.floor(rect[1]) + 'px';
      element.style.width = Math.ceil(rect[2] - rect[0]) + 'px';
      element.style.height = Math.ceil(rect[3] - rect[1]) + 'px';
      return element;
    }
    function createTextAnnotation(item) {
      var container = document.createElement('section');
      container.className = 'annotText';

      var rect = viewport.convertToViewportRectangle(item.rect);
      rect = PDFJS.Util.normalizeRect(rect);
      // sanity check because of OOo-generated PDFs
      if ((rect[3] - rect[1]) < ANNOT_MIN_SIZE) {
        rect[3] = rect[1] + ANNOT_MIN_SIZE;
      }
      if ((rect[2] - rect[0]) < ANNOT_MIN_SIZE) {
        rect[2] = rect[0] + (rect[3] - rect[1]); // make it square
      }
      var image = createElementWithStyle('img', item, rect);
      var iconName = item.name;
      image.src = IMAGE_DIR + 'annotation-' +
        iconName.toLowerCase() + '.svg';
      image.alt = mozL10n.get('text_annotation_type', {type: iconName},
        '[{{type}} Annotation]');
      var content = document.createElement('div');
      content.setAttribute('hidden', true);
      var title = document.createElement('h1');
      var text = document.createElement('p');
      content.style.left = Math.floor(rect[2]) + 'px';
      content.style.top = Math.floor(rect[1]) + 'px';
      title.textContent = item.title;

      if (!item.content && !item.title) {
        content.setAttribute('hidden', true);
      } else {
        var e = document.createElement('span');
        var lines = item.content.split(/(?:\r\n?|\n)/);
        for (var i = 0, ii = lines.length; i < ii; ++i) {
          var line = lines[i];
          e.appendChild(document.createTextNode(line));
          if (i < (ii - 1))
            e.appendChild(document.createElement('br'));
        }
        text.appendChild(e);
        image.addEventListener('mouseover', function annotationImageOver() {
           content.removeAttribute('hidden');
        }, false);

        image.addEventListener('mouseout', function annotationImageOut() {
           content.setAttribute('hidden', true);
        }, false);
      }

      content.appendChild(title);
      content.appendChild(text);
      container.appendChild(image);
      container.appendChild(content);

      return container;
    }

    pdfPage.getAnnotations().then(function(items) {
      for (var i = 0; i < items.length; i++) {
        var item = items[i];
        switch (item.type) {
          case 'Link':
            var link = createElementWithStyle('a', item);
            link.href = item.url || '';
            if (!item.url)
              bindLink(link, ('dest' in item) ? item.dest : null);
            div.appendChild(link);
            break;
          case 'Text':
            var textAnnotation = createTextAnnotation(item);
            if (textAnnotation)
              div.appendChild(textAnnotation);
            break;
        }
      }
    });
  }

  this.getPagePoint = function pageViewGetPagePoint(x, y) {
    return this.viewport.convertToPdfPoint(x, y);
  };

  this.scrollIntoView = function pageViewScrollIntoView(dest) {
      if (!dest) {
        scrollIntoView(div);
        return;
      }

      var x = 0, y = 0;
      var width = 0, height = 0, widthScale, heightScale;
      var scale = 0;
      switch (dest[1].name) {
        case 'XYZ':
          x = dest[2];
          y = dest[3];
          scale = dest[4];
          break;
        case 'Fit':
        case 'FitB':
          scale = 'page-fit';
          break;
        case 'FitH':
        case 'FitBH':
          y = dest[2];
          scale = 'page-width';
          break;
        case 'FitV':
        case 'FitBV':
          x = dest[2];
          scale = 'page-height';
          break;
        case 'FitR':
          x = dest[2];
          y = dest[3];
          width = dest[4] - x;
          height = dest[5] - y;
          widthScale = (this.container.clientWidth - SCROLLBAR_PADDING) /
            width / CSS_UNITS;
          heightScale = (this.container.clientHeight - SCROLLBAR_PADDING) /
            height / CSS_UNITS;
          scale = Math.min(widthScale, heightScale);
          break;
        default:
          return;
      }

      if (scale && scale !== PDFView.currentScale)
        PDFView.parseScale(scale, true, true);
      else if (PDFView.currentScale === UNKNOWN_SCALE)
        PDFView.parseScale(DEFAULT_SCALE, true, true);

      var boundingRect = [
        this.viewport.convertToViewportPoint(x, y),
        this.viewport.convertToViewportPoint(x + width, y + height)
      ];
      setTimeout(function pageViewScrollIntoViewRelayout() {
        // letting page to re-layout before scrolling
        var scale = PDFView.currentScale;
        var x = Math.min(boundingRect[0][0], boundingRect[1][0]);
        var y = Math.min(boundingRect[0][1], boundingRect[1][1]);
        var width = Math.abs(boundingRect[0][0] - boundingRect[1][0]);
        var height = Math.abs(boundingRect[0][1] - boundingRect[1][1]);

        scrollIntoView(div, {left: x, top: y, width: width, height: height});
      }, 0);
  };

  this.getTextContent = function pageviewGetTextContent() {
    if (!this.textContent) {
      this.textContent = this.pdfPage.getTextContent();
    }
    return this.textContent;
  };

  this.draw = function pageviewDraw(callback) {
    if (this.renderingState !== RenderingStates.INITIAL)
      error('Must be in new state before drawing');

    this.renderingState = RenderingStates.RUNNING;

    var canvas = document.createElement('canvas');
    canvas.id = 'page' + this.id;
    canvas.mozOpaque = true;
    div.appendChild(canvas);
    this.canvas = canvas;

    var textLayerDiv = null;
    if (!PDFJS.disableTextLayer) {
      textLayerDiv = document.createElement('div');
      textLayerDiv.className = 'textLayer';
      div.appendChild(textLayerDiv);
    }
    var textLayer = this.textLayer =
          textLayerDiv ? new TextLayerBuilder(textLayerDiv, this.id - 1) : null;

    var scale = this.scale, viewport = this.viewport;
    var outputScale = PDFView.getOutputScale();
    canvas.width = Math.floor(viewport.width) * outputScale.sx;
    canvas.height = Math.floor(viewport.height) * outputScale.sy;

    if (outputScale.scaled) {
      var cssScale = 'scale(' + (1 / outputScale.sx) + ', ' +
                                (1 / outputScale.sy) + ')';
      CustomStyle.setProp('transform' , canvas, cssScale);
      CustomStyle.setProp('transformOrigin' , canvas, '0% 0%');
      if (textLayerDiv) {
        CustomStyle.setProp('transform' , textLayerDiv, cssScale);
        CustomStyle.setProp('transformOrigin' , textLayerDiv, '0% 0%');
      }
    }

    var ctx = canvas.getContext('2d');
    // TODO(mack): use data attributes to store these
    ctx._scaleX = outputScale.sx;
    ctx._scaleY = outputScale.sy;
    ctx.save();
    ctx.fillStyle = 'rgb(255, 255, 255)';
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    ctx.restore();
    if (outputScale.scaled) {
      ctx.scale(outputScale.sx, outputScale.sy);
    }
//#if (FIREFOX || MOZCENTRAL)
//  // Checking if document fonts are used only once
//  var checkIfDocumentFontsUsed = !PDFView.pdfDocument.embeddedFontsUsed;
//#endif

    // Rendering area

    var self = this;
    var renderingWasReset = false;
    function pageViewDrawCallback(error) {
      if (renderingWasReset) {
        return;
      }

      self.renderingState = RenderingStates.FINISHED;

      if (self.loadingIconDiv) {
        div.removeChild(self.loadingIconDiv);
        delete self.loadingIconDiv;
      }

//#if (FIREFOX || MOZCENTRAL)
//    if (checkIfDocumentFontsUsed && PDFView.pdfDocument.embeddedFontsUsed &&
//        !PDFView.supportsDocumentFonts) {
//      console.error(mozL10n.get('web_fonts_disabled', null,
//        'Web fonts are disabled: unable to use embedded PDF fonts.'));
//      PDFView.fallback();
//    }
//#endif
      if (error) {
        PDFView.error(mozL10n.get('rendering_error', null,
          'An error occurred while rendering the page.'), error);
      }

      self.stats = pdfPage.stats;
      self.updateStats();
      if (self.onAfterDraw)
        self.onAfterDraw();

      cache.push(self);
      callback();
    }

    var renderContext = {
      canvasContext: ctx,
      viewport: this.viewport,
      textLayer: textLayer,
      continueCallback: function pdfViewcContinueCallback(cont) {
        if (self.renderingState === RenderingStates.INITIAL) {
          // The page update() was called, we just need to abort any rendering.
          renderingWasReset = true;
          return;
        }

        if (PDFView.highestPriorityPage !== 'page' + self.id) {
          self.renderingState = RenderingStates.PAUSED;
          self.resume = function resumeCallback() {
            self.renderingState = RenderingStates.RUNNING;
            cont();
          };
          return;
        }
        cont();
      }
    };
    this.pdfPage.render(renderContext).then(
      function pdfPageRenderCallback() {
        pageViewDrawCallback(null);
      },
      function pdfPageRenderError(error) {
        pageViewDrawCallback(error);
      }
    );

    if (textLayer) {
      this.getTextContent().then(
        function textContentResolved(textContent) {
          textLayer.setTextContent(textContent);
        }
      );
    }

    setupAnnotations(this.pdfPage, this.viewport);
    div.setAttribute('data-loaded', true);
  };

  this.beforePrint = function pageViewBeforePrint() {
    var pdfPage = this.pdfPage;
    var viewport = pdfPage.getViewport(1);
    // Use the same hack we use for high dpi displays for printing to get better
    // output until bug 811002 is fixed in FF.
    var PRINT_OUTPUT_SCALE = 2;
    var canvas = this.canvas = document.createElement('canvas');
    canvas.width = Math.floor(viewport.width) * PRINT_OUTPUT_SCALE;
    canvas.height = Math.floor(viewport.height) * PRINT_OUTPUT_SCALE;
    canvas.style.width = (PRINT_OUTPUT_SCALE * viewport.width) + 'pt';
    canvas.style.height = (PRINT_OUTPUT_SCALE * viewport.height) + 'pt';
    var cssScale = 'scale(' + (1 / PRINT_OUTPUT_SCALE) + ', ' +
                              (1 / PRINT_OUTPUT_SCALE) + ')';
    CustomStyle.setProp('transform' , canvas, cssScale);
    CustomStyle.setProp('transformOrigin' , canvas, '0% 0%');

    var printContainer = document.getElementById('printContainer');
    printContainer.appendChild(canvas);

    var self = this;
    canvas.mozPrintCallback = function(obj) {
      var ctx = obj.context;

      ctx.save();
      ctx.fillStyle = 'rgb(255, 255, 255)';
      ctx.fillRect(0, 0, canvas.width, canvas.height);
      ctx.restore();
      ctx.scale(PRINT_OUTPUT_SCALE, PRINT_OUTPUT_SCALE);

      var renderContext = {
        canvasContext: ctx,
        viewport: viewport
      };

      pdfPage.render(renderContext).then(function() {
        // Tell the printEngine that rendering this canvas/page has finished.
        obj.done();
        self.pdfPage.destroy();
      }, function(error) {
        console.error(error);
        // Tell the printEngine that rendering this canvas/page has failed.
        // This will make the print proces stop.
        if ('abort' in object)
          obj.abort();
        else
          obj.done();
        self.pdfPage.destroy();
      });
    };
  };

  this.updateStats = function pageViewUpdateStats() {
    if (PDFJS.pdfBug && Stats.enabled) {
      var stats = this.stats;
      Stats.add(this.id, stats);
    }
  };
};

var ThumbnailView = function thumbnailView(container, pdfPage, id) {
  var anchor = document.createElement('a');
  anchor.href = PDFView.getAnchorUrl('#page=' + id);
  anchor.title = mozL10n.get('thumb_page_title', {page: id}, 'Page {{page}}');
  anchor.onclick = function stopNavigation() {
    PDFView.page = id;
    return false;
  };

  var rotation = 0;
  var totalRotation = (rotation + pdfPage.rotate) % 360;
  var viewport = pdfPage.getViewport(1, totalRotation);
  var pageWidth = this.width = viewport.width;
  var pageHeight = this.height = viewport.height;
  var pageRatio = pageWidth / pageHeight;
  this.id = id;

  var canvasWidth = 98;
  var canvasHeight = canvasWidth / this.width * this.height;
  var scaleX = this.scaleX = (canvasWidth / pageWidth);
  var scaleY = this.scaleY = (canvasHeight / pageHeight);

  var div = this.el = document.createElement('div');
  div.id = 'thumbnailContainer' + id;
  div.className = 'thumbnail';

  if (id === 1) {
    // Highlight the thumbnail of the first page when no page number is
    // specified (or exists in cache) when the document is loaded.
    div.classList.add('selected');
  }

  var ring = document.createElement('div');
  ring.className = 'thumbnailSelectionRing';
  ring.style.width = canvasWidth + 'px';
  ring.style.height = canvasHeight + 'px';

  div.appendChild(ring);
  anchor.appendChild(div);
  container.appendChild(anchor);

  this.hasImage = false;
  this.renderingState = RenderingStates.INITIAL;

  this.updateRotation = function(rot) {

    rotation = rot;
    totalRotation = (rotation + pdfPage.rotate) % 360;
    viewport = pdfPage.getViewport(1, totalRotation);
    pageWidth = this.width = viewport.width;
    pageHeight = this.height = viewport.height;
    pageRatio = pageWidth / pageHeight;

    canvasHeight = canvasWidth / this.width * this.height;
    scaleX = this.scaleX = (canvasWidth / pageWidth);
    scaleY = this.scaleY = (canvasHeight / pageHeight);

    div.removeAttribute('data-loaded');
    ring.textContent = '';
    ring.style.width = canvasWidth + 'px';
    ring.style.height = canvasHeight + 'px';

    this.hasImage = false;
    this.renderingState = RenderingStates.INITIAL;
    this.resume = null;
  }

  function getPageDrawContext() {
    var canvas = document.createElement('canvas');
    canvas.id = 'thumbnail' + id;
    canvas.mozOpaque = true;

    canvas.width = canvasWidth;
    canvas.height = canvasHeight;
    canvas.className = 'thumbnailImage';
    canvas.setAttribute('aria-label', mozL10n.get('thumb_page_canvas',
      {page: id}, 'Thumbnail of Page {{page}}'));

    div.setAttribute('data-loaded', true);

    ring.appendChild(canvas);

    var ctx = canvas.getContext('2d');
    ctx.save();
    ctx.fillStyle = 'rgb(255, 255, 255)';
    ctx.fillRect(0, 0, canvasWidth, canvasHeight);
    ctx.restore();
    return ctx;
  }

  this.drawingRequired = function thumbnailViewDrawingRequired() {
    return !this.hasImage;
  };

  this.draw = function thumbnailViewDraw(callback) {
    if (this.renderingState !== RenderingStates.INITIAL)
      error('Must be in new state before drawing');

    this.renderingState = RenderingStates.RUNNING;
    if (this.hasImage) {
      callback();
      return;
    }

    var self = this;
    var ctx = getPageDrawContext();
    var drawViewport = pdfPage.getViewport(scaleX, totalRotation);
    var renderContext = {
      canvasContext: ctx,
      viewport: drawViewport,
      continueCallback: function(cont) {
        if (PDFView.highestPriorityPage !== 'thumbnail' + self.id) {
          self.renderingState = RenderingStates.PAUSED;
          self.resume = function() {
            self.renderingState = RenderingStates.RUNNING;
            cont();
          };
          return;
        }
        cont();
      }
    };
    pdfPage.render(renderContext).then(
      function pdfPageRenderCallback() {
        self.renderingState = RenderingStates.FINISHED;
        callback();
      },
      function pdfPageRenderError(error) {
        self.renderingState = RenderingStates.FINISHED;
        callback();
      }
    );
    this.hasImage = true;
  };

  this.setImage = function thumbnailViewSetImage(img) {
    if (this.hasImage || !img)
      return;
    this.renderingState = RenderingStates.FINISHED;
    var ctx = getPageDrawContext();
    ctx.drawImage(img, 0, 0, img.width, img.height,
                  0, 0, ctx.canvas.width, ctx.canvas.height);

    this.hasImage = true;
  };
};

var DocumentOutlineView = function documentOutlineView(outline) {
  var outlineView = document.getElementById('outlineView');
  while (outlineView.firstChild)
    outlineView.removeChild(outlineView.firstChild);

  function bindItemLink(domObj, item) {
    domObj.href = PDFView.getDestinationHash(item.dest);
    domObj.onclick = function documentOutlineViewOnclick(e) {
      PDFView.navigateTo(item.dest);
      return false;
    };
  }

  if (!outline) {
    var noOutline = document.createElement('div');
    noOutline.classList.add('noOutline');
    noOutline.textContent = mozL10n.get('no_outline', null,
      'No Outline Available');
    outlineView.appendChild(noOutline);
    return;
  }

  var queue = [{parent: outlineView, items: outline}];
  while (queue.length > 0) {
    var levelData = queue.shift();
    var i, n = levelData.items.length;
    for (i = 0; i < n; i++) {
      var item = levelData.items[i];
      var div = document.createElement('div');
      div.className = 'outlineItem';
      var a = document.createElement('a');
      bindItemLink(a, item);
      a.textContent = item.title;
      div.appendChild(a);

      if (item.items.length > 0) {
        var itemsDiv = document.createElement('div');
        itemsDiv.className = 'outlineItems';
        div.appendChild(itemsDiv);
        queue.push({parent: itemsDiv, items: item.items});
      }

      levelData.parent.appendChild(div);
    }
  }
};

// optimised CSS custom property getter/setter
var CustomStyle = (function CustomStyleClosure() {

  // As noted on: http://www.zachstronaut.com/posts/2009/02/17/
  //              animate-css-transforms-firefox-webkit.html
  // in some versions of IE9 it is critical that ms appear in this list
  // before Moz
  var prefixes = ['ms', 'Moz', 'Webkit', 'O'];
  var _cache = { };

  function CustomStyle() {
  }

  CustomStyle.getProp = function get(propName, element) {
    // check cache only when no element is given
    if (arguments.length == 1 && typeof _cache[propName] == 'string') {
      return _cache[propName];
    }

    element = element || document.documentElement;
    var style = element.style, prefixed, uPropName;

    // test standard property first
    if (typeof style[propName] == 'string') {
      return (_cache[propName] = propName);
    }

    // capitalize
    uPropName = propName.charAt(0).toUpperCase() + propName.slice(1);

    // test vendor specific properties
    for (var i = 0, l = prefixes.length; i < l; i++) {
      prefixed = prefixes[i] + uPropName;
      if (typeof style[prefixed] == 'string') {
        return (_cache[propName] = prefixed);
      }
    }

    //if all fails then set to undefined
    return (_cache[propName] = 'undefined');
  };

  CustomStyle.setProp = function set(propName, element, str) {
    var prop = this.getProp(propName);
    if (prop != 'undefined')
      element.style[prop] = str;
  };

  return CustomStyle;
})();

var TextLayerBuilder = function textLayerBuilder(textLayerDiv, pageIdx) {
  var textLayerFrag = document.createDocumentFragment();

  this.textLayerDiv = textLayerDiv;
  this.layoutDone = false;
  this.divContentDone = false;
  this.pageIdx = pageIdx;
  this.matches = [];

  this.beginLayout = function textLayerBuilderBeginLayout() {
    this.textDivs = [];
    this.textLayerQueue = [];
    this.renderingDone = false;
  };

  this.endLayout = function textLayerBuilderEndLayout() {
    this.layoutDone = true;
    this.insertDivContent();
  };

  this.renderLayer = function textLayerBuilderRenderLayer() {
    var self = this;
    var textDivs = this.textDivs;
    var textLayerDiv = this.textLayerDiv;
    var canvas = document.createElement('canvas');
    var ctx = canvas.getContext('2d');

    // No point in rendering so many divs as it'd make the browser unusable
    // even after the divs are rendered
    var MAX_TEXT_DIVS_TO_RENDER = 100000;
    if (textDivs.length > MAX_TEXT_DIVS_TO_RENDER)
      return;

    for (var i = 0, ii = textDivs.length; i < ii; i++) {
      var textDiv = textDivs[i];
      textLayerFrag.appendChild(textDiv);

      ctx.font = textDiv.style.fontSize + ' ' + textDiv.style.fontFamily;
      var width = ctx.measureText(textDiv.textContent).width;

      if (width > 0) {
        var textScale = textDiv.dataset.canvasWidth / width;

        CustomStyle.setProp('transform' , textDiv,
          'scale(' + textScale + ', 1)');
        CustomStyle.setProp('transformOrigin' , textDiv, '0% 0%');

        textLayerDiv.appendChild(textDiv);
      }
    }

    this.renderingDone = true;
    this.updateMatches();

    textLayerDiv.appendChild(textLayerFrag);
  };

  this.setupRenderLayoutTimer = function textLayerSetupRenderLayoutTimer() {
    // Schedule renderLayout() if user has been scrolling, otherwise
    // run it right away
    var RENDER_DELAY = 200; // in ms
    var self = this;
    if (Date.now() - PDFView.lastScroll > RENDER_DELAY) {
      // Render right away
      this.renderLayer();
    } else {
      // Schedule
      if (this.renderTimer)
        clearTimeout(this.renderTimer);
      this.renderTimer = setTimeout(function() {
        self.setupRenderLayoutTimer();
      }, RENDER_DELAY);
    }
  };

  this.appendText = function textLayerBuilderAppendText(geom) {
    var textDiv = document.createElement('div');

    // vScale and hScale already contain the scaling to pixel units
    var fontHeight = geom.fontSize * geom.vScale;
    textDiv.dataset.canvasWidth = geom.canvasWidth * geom.hScale;
    textDiv.dataset.fontName = geom.fontName;

    textDiv.style.fontSize = fontHeight + 'px';
    textDiv.style.fontFamily = geom.fontFamily;
    textDiv.style.left = geom.x + 'px';
    textDiv.style.top = (geom.y - fontHeight) + 'px';

    // The content of the div is set in the `setTextContent` function.

    this.textDivs.push(textDiv);
  };

  this.insertDivContent = function textLayerUpdateTextContent() {
    // Only set the content of the divs once layout has finished, the content
    // for the divs is available and content is not yet set on the divs.
    if (!this.layoutDone || this.divContentDone || !this.textContent)
      return;

    this.divContentDone = true;

    var textDivs = this.textDivs;
    var bidiTexts = this.textContent.bidiTexts;

    for (var i = 0; i < bidiTexts.length; i++) {
      var bidiText = bidiTexts[i];
      var textDiv = textDivs[i];

      textDiv.textContent = bidiText.str;
      textDiv.dir = bidiText.ltr ? 'ltr' : 'rtl';
    }

    this.setupRenderLayoutTimer();
  };

  this.setTextContent = function textLayerBuilderSetTextContent(textContent) {
    this.textContent = textContent;
    this.insertDivContent();
  };

  this.convertMatches = function textLayerBuilderConvertMatches(matches) {
    var i = 0;
    var iIndex = 0;
    var bidiTexts = this.textContent.bidiTexts;
    var end = bidiTexts.length - 1;
    var queryLen = PDFFindController.state.query.length;

    var lastDivIdx = -1;
    var pos;

    var ret = [];

    // Loop over all the matches.
    for (var m = 0; m < matches.length; m++) {
      var matchIdx = matches[m];
      // # Calculate the begin position.

      // Loop over the divIdxs.
      while (i !== end && matchIdx >= (iIndex + bidiTexts[i].str.length)) {
        iIndex += bidiTexts[i].str.length;
        i++;
      }

      // TODO: Do proper handling here if something goes wrong.
      if (i == bidiTexts.length) {
        console.error('Could not find matching mapping');
      }

      var match = {
        begin: {
          divIdx: i,
          offset: matchIdx - iIndex
        }
      };

      // # Calculate the end position.
      matchIdx += queryLen;

      // Somewhat same array as above, but use a > instead of >= to get the end
      // position right.
      while (i !== end && matchIdx > (iIndex + bidiTexts[i].str.length)) {
        iIndex += bidiTexts[i].str.length;
        i++;
      }

      match.end = {
        divIdx: i,
        offset: matchIdx - iIndex
      };
      ret.push(match);
    }

    return ret;
  };

  this.renderMatches = function textLayerBuilder_renderMatches(matches) {
    // Early exit if there is nothing to render.
    if (matches.length === 0) {
      return;
    }

    var bidiTexts = this.textContent.bidiTexts;
    var textDivs = this.textDivs;
    var prevEnd = null;
    var isSelectedPage = this.pageIdx === PDFFindController.selected.pageIdx;
    var selectedMatchIdx = PDFFindController.selected.matchIdx;
    var highlightAll = PDFFindController.state.highlightAll;

    var infty = {
      divIdx: -1,
      offset: undefined
    };

    function beginText(begin, className) {
      var divIdx = begin.divIdx;
      var div = textDivs[divIdx];
      div.textContent = '';

      var content = bidiTexts[divIdx].str.substring(0, begin.offset);
      var node = document.createTextNode(content);
      if (className) {
        var isSelected = isSelectedPage &&
                          divIdx === selectedMatchIdx;
        var span = document.createElement('span');
        span.className = className + (isSelected ? ' selected' : '');
        span.appendChild(node);
        div.appendChild(span);
        return;
      }
      div.appendChild(node);
    }

    function appendText(from, to, className) {
      var divIdx = from.divIdx;
      var div = textDivs[divIdx];

      var content = bidiTexts[divIdx].str.substring(from.offset, to.offset);
      var node = document.createTextNode(content);
      if (className) {
        var span = document.createElement('span');
        span.className = className;
        span.appendChild(node);
        div.appendChild(span);
        return;
      }
      div.appendChild(node);
    }

    function highlightDiv(divIdx, className) {
      textDivs[divIdx].className = className;
    }

    var i0 = selectedMatchIdx, i1 = i0 + 1, i;

    if (highlightAll) {
      i0 = 0;
      i1 = matches.length;
    } else if (!isSelectedPage) {
      // Not highlighting all and this isn't the selected page, so do nothing.
      return;
    }

    for (i = i0; i < i1; i++) {
      var match = matches[i];
      var begin = match.begin;
      var end = match.end;

      var isSelected = isSelectedPage && i === selectedMatchIdx;
      var highlightSuffix = (isSelected ? ' selected' : '');
      if (isSelected)
        scrollIntoView(textDivs[begin.divIdx], {top: -50});

      // Match inside new div.
      if (!prevEnd || begin.divIdx !== prevEnd.divIdx) {
        // If there was a previous div, then add the text at the end
        if (prevEnd !== null) {
          appendText(prevEnd, infty);
        }
        // clears the divs and set the content until the begin point.
        beginText(begin);
      } else {
        appendText(prevEnd, begin);
      }

      if (begin.divIdx === end.divIdx) {
        appendText(begin, end, 'highlight' + highlightSuffix);
      } else {
        appendText(begin, infty, 'highlight begin' + highlightSuffix);
        for (var n = begin.divIdx + 1; n < end.divIdx; n++) {
          highlightDiv(n, 'highlight middle' + highlightSuffix);
        }
        beginText(end, 'highlight end' + highlightSuffix);
      }
      prevEnd = end;
    }

    if (prevEnd) {
      appendText(prevEnd, infty);
    }
  };

  this.updateMatches = function textLayerUpdateMatches() {
    // Only show matches, once all rendering is done.
    if (!this.renderingDone)
      return;

    // Clear out all matches.
    var matches = this.matches;
    var textDivs = this.textDivs;
    var bidiTexts = this.textContent.bidiTexts;
    var clearedUntilDivIdx = -1;

    // Clear out all current matches.
    for (var i = 0; i < matches.length; i++) {
      var match = matches[i];
      var begin = Math.max(clearedUntilDivIdx, match.begin.divIdx);
      for (var n = begin; n <= match.end.divIdx; n++) {
        var div = textDivs[n];
        div.textContent = bidiTexts[n].str;
        div.className = '';
      }
      clearedUntilDivIdx = match.end.divIdx + 1;
    }

    if (!PDFFindController.active)
      return;

    // Convert the matches on the page controller into the match format used
    // for the textLayer.
    this.matches = matches =
      this.convertMatches(PDFFindController.pageMatches[this.pageIdx] || []);

    this.renderMatches(this.matches);
  };
};

document.addEventListener('DOMContentLoaded', function webViewerLoad(evt) {
  PDFView.initialize();
  var params = PDFView.parseQueryString(document.location.search.substring(1));

//#if !(FIREFOX || MOZCENTRAL)
  var file = params.file || DEFAULT_URL;
//#else
//var file = window.location.toString()
//#endif

//#if !(FIREFOX || MOZCENTRAL)
//  if (!window.File || !window.FileReader || !window.FileList || !window.Blob) {
//    document.getElementById('openFile').setAttribute('hidden', 'true');
//  } else {
//    document.getElementById('fileInput').value = null;
//  }
//#else
//document.getElementById('openFile').setAttribute('hidden', 'true');
//#endif

  // Special debugging flags in the hash section of the URL.
  var hash = document.location.hash.substring(1);
  var hashParams = PDFView.parseQueryString(hash);

  if ('disableWorker' in hashParams)
    PDFJS.disableWorker = (hashParams['disableWorker'] === 'true');

//#if !(FIREFOX || MOZCENTRAL)
  var locale = navigator.language;
  if ('locale' in hashParams)
    locale = hashParams['locale'];
  mozL10n.setLanguage(locale);
//#endif

  if ('textLayer' in hashParams) {
    switch (hashParams['textLayer']) {
      case 'off':
        PDFJS.disableTextLayer = true;
        break;
      case 'visible':
      case 'shadow':
      case 'hover':
        var viewer = document.getElementById('viewer');
        viewer.classList.add('textLayer-' + hashParams['textLayer']);
        break;
    }
  }

//#if !(FIREFOX || MOZCENTRAL)
  if ('pdfBug' in hashParams) {
//#else
//if ('pdfBug' in hashParams && FirefoxCom.requestSync('pdfBugEnabled')) {
//#endif
    PDFJS.pdfBug = true;
    var pdfBug = hashParams['pdfBug'];
    var enabled = pdfBug.split(',');
    PDFBug.enable(enabled);
    PDFBug.init();
  }

//  if (!PDFView.supportsPrinting) {
//    document.getElementById('print').classList.add('hidden');
//  }
//
//  if (!PDFView.supportsFullscreen) {
//    document.getElementById('fullscreen').classList.add('hidden');
//  }
//
//  if (PDFView.supportsIntegratedFind) {
//    document.querySelector('#viewFind').classList.add('hidden');
//  }

  // Listen for warnings to trigger the fallback UI.  Errors should be caught
  // and call PDFView.error() so we don't need to listen for those.
  PDFJS.LogManager.addLogger({
    warn: function() {
      PDFView.fallback();
    }
  });

  var mainContainer = document.getElementById('mainContainer');
  var outerContainer = document.getElementById('outerContainer');
  mainContainer.addEventListener('transitionend', function(e) {
    if (e.target == mainContainer) {
      var event = document.createEvent('UIEvents');
      event.initUIEvent('resize', false, false, window, 0);
      window.dispatchEvent(event);
      outerContainer.classList.remove('sidebarMoving');
    }
  }, true);

//  document.getElementById('sidebarToggle').addEventListener('click',
//    function() {
//      this.classList.toggle('toggled');
//      outerContainer.classList.add('sidebarMoving');
//      outerContainer.classList.toggle('sidebarOpen');
//      PDFView.sidebarOpen = outerContainer.classList.contains('sidebarOpen');
//      PDFView.renderHighestPriority();
//    });
//
//  document.getElementById('viewThumbnail').addEventListener('click',
//    function() {
//      PDFView.switchSidebarView('thumbs');
//    });
//
//  document.getElementById('viewOutline').addEventListener('click',
//    function() {
//      PDFView.switchSidebarView('outline');
//    });

  document.getElementById('previous').addEventListener('click',
    function() {
      PDFView.page--;
    });

  document.getElementById('next').addEventListener('click',
    function() {
      PDFView.page++;
    });

  document.querySelector('.zoomIn').addEventListener('click',
    function() {
      PDFView.zoomIn();
    });

  document.querySelector('.zoomOut').addEventListener('click',
    function() {
      PDFView.zoomOut();
    });

//  document.getElementById('fullscreen').addEventListener('click',
//    function() {
//      PDFView.fullscreen();
//    });
//
//  document.getElementById('openFile').addEventListener('click',
//    function() {
//      document.getElementById('fileInput').click();
//    });
//
//  document.getElementById('print').addEventListener('click',
//    function() {
//      window.print();
//    });
//
//  document.getElementById('download').addEventListener('click',
//    function() {
//      PDFView.download();
//    });

  document.getElementById('pageNumber').addEventListener('click',
    function() {
      this.select();
    });

  document.getElementById('pageNumber').addEventListener('change',
    function() {
      // Handle the user inputting a floating point number.
      PDFView.page = (this.value | 0);

      if (this.value !== (this.value | 0).toString()) {
        this.value = PDFView.page;
      }
    });

  document.getElementById('scaleSelect').addEventListener('change',
    function() {
      PDFView.parseScale(this.value);
    });

  document.getElementById('first_page').addEventListener('click',
    function() {
      PDFView.page = 1;
    });

  document.getElementById('last_page').addEventListener('click',
    function() {
      PDFView.page = PDFView.pdfDocument.numPages;
    });

  document.getElementById('page_rotate_ccw').addEventListener('click',
    function() {
      PDFView.rotatePages(-90);
    });

  document.getElementById('page_rotate_cw').addEventListener('click',
    function() {
      PDFView.rotatePages(90);
    });

//#if (FIREFOX || MOZCENTRAL)
//if (FirefoxCom.requestSync('getLoadingType') == 'passive') {
//  PDFView.setTitleUsingUrl(file);
//  PDFView.initPassiveLoading();
//  return;
//}
//#endif

//#if !B2G
  PDFView.open(file, 0);
//#endif
}, true);

function updateViewarea() {

  if (!PDFView.initialized)
    return;
  var visible = PDFView.getVisiblePages();
  var visiblePages = visible.views;
  if (visiblePages.length === 0) {
    return;
  }

  PDFView.renderHighestPriority();

  var currentId = PDFView.page;
  var firstPage = visible.first;

  for (var i = 0, ii = visiblePages.length, stillFullyVisible = false;
       i < ii; ++i) {
    var page = visiblePages[i];

    if (page.percent < 100)
      break;

    if (page.id === PDFView.page) {
      stillFullyVisible = true;
      break;
    }
  }

  if (!stillFullyVisible) {
    currentId = visiblePages[0].id;
  }

  if (!PDFView.isFullscreen) {
    updateViewarea.inProgress = true; // used in "set page"
    PDFView.page = currentId;
    updateViewarea.inProgress = false;
  }

  var currentScale = PDFView.currentScale;
  var currentScaleValue = PDFView.currentScaleValue;
  var normalizedScaleValue = currentScaleValue == currentScale ?
    currentScale * 100 : currentScaleValue;

  var pageNumber = firstPage.id;
  var pdfOpenParams = '#page=' + pageNumber;
  pdfOpenParams += '&zoom=' + normalizedScaleValue;
  var currentPage = PDFView.pages[pageNumber - 1];
  var topLeft = currentPage.getPagePoint(PDFView.container.scrollLeft,
    (PDFView.container.scrollTop - firstPage.y));
  pdfOpenParams += ',' + Math.round(topLeft[0]) + ',' + Math.round(topLeft[1]);

  var store = PDFView.store;
  store.initializedPromise.then(function() {
    store.set('exists', true);
    store.set('page', pageNumber);
    store.set('zoom', normalizedScaleValue);
    store.set('scrollLeft', Math.round(topLeft[0]));
    store.set('scrollTop', Math.round(topLeft[1]));
  });
//  var href = PDFView.getAnchorUrl(pdfOpenParams);
//  document.getElementById('viewBookmark').href = href;
}

window.addEventListener('resize', function webViewerResize(evt) {
  if (PDFView.initialized &&
      (document.getElementById('pageWidthOption').selected ||
      document.getElementById('pageFitOption').selected ||
      document.getElementById('pageAutoOption').selected))
      PDFView.parseScale(document.getElementById('scaleSelect').value);
  updateViewarea();
});

window.addEventListener('hashchange', function webViewerHashchange(evt) {
  PDFView.setHash(document.location.hash.substring(1));
});

window.addEventListener('change', function webViewerChange(evt) {
  var files = evt.target.files;
  if (!files || files.length == 0)
    return;

  // Read the local file into a Uint8Array.
  var fileReader = new FileReader();
  fileReader.onload = function webViewerChangeFileReaderOnload(evt) {
    var buffer = evt.target.result;
    var uint8Array = new Uint8Array(buffer);
    PDFView.open(uint8Array, 0);
  };

  var file = files[0];
  fileReader.readAsArrayBuffer(file);
  PDFView.setTitleUsingUrl(file.name);

  // URL does not reflect proper document location - hiding some icons.
  document.getElementById('viewBookmark').setAttribute('hidden', 'true');
  document.getElementById('download').setAttribute('hidden', 'true');
}, true);

function selectScaleOption(value) {
  var options = document.getElementById('scaleSelect').options;
  var predefinedValueFound = false;
  for (var i = 0; i < options.length; i++) {
    var option = options[i];
    if (option.value != value) {
      option.selected = false;
      continue;
    }
    option.selected = true;
    predefinedValueFound = true;
  }
  return predefinedValueFound;
}

window.addEventListener('localized', function localized(evt) {
  document.getElementsByTagName('html')[0].dir = mozL10n.getDirection();

  // Adjust the width of the zoom box to fit the content.
  var container = document.getElementById('scaleSelectContainer');
  var select = document.getElementById('scaleSelect');

  select.setAttribute('style', 'min-width: inherit;');
  var width = select.clientWidth + 8;
  container.setAttribute('style', 'min-width: ' + width + 'px; ' +
                                  'max-width: ' + width + 'px;');
  select.setAttribute('style', 'min-width: ' + (width + 20) + 'px;');
}, true);

window.addEventListener('scalechange', function scalechange(evt) {
  var customScaleOption = document.getElementById('customScaleOption');
  customScaleOption.selected = false;

  if (!evt.resetAutoSettings &&
       (document.getElementById('pageWidthOption').selected ||
        document.getElementById('pageFitOption').selected ||
        document.getElementById('pageAutoOption').selected)) {
      updateViewarea();
      return;
  }

  var predefinedValueFound = selectScaleOption('' + evt.scale);
  if (!predefinedValueFound) {
    customScaleOption.textContent = Math.round(evt.scale * 10000) / 100 + '%';
    customScaleOption.selected = true;
  }

  updateViewarea();
}, true);

window.addEventListener('pagechange', function pagechange(evt) {
  var page = evt.pageNumber;
  if (PDFView.previousPageNumber !== page) {
    document.getElementById('pageNumber').value = page;
    var selected = document.querySelector('.thumbnail.selected');
    if (selected)
      selected.classList.remove('selected');
    var thumbnail = document.getElementById('thumbnailContainer' + page);
    thumbnail.classList.add('selected');
    var visibleThumbs = PDFView.getVisibleThumbs();
    var numVisibleThumbs = visibleThumbs.views.length;
    // If the thumbnail isn't currently visible scroll it into view.
    if (numVisibleThumbs > 0) {
      var first = visibleThumbs.first.id;
      // Account for only one thumbnail being visible.
      var last = numVisibleThumbs > 1 ?
                  visibleThumbs.last.id : first;
      if (page <= first || page >= last)
        scrollIntoView(thumbnail);
    }

  }
  document.getElementById('previous').disabled = (page <= 1);
  document.getElementById('next').disabled = (page >= PDFView.pages.length);
}, true);

// Firefox specific event, so that we can prevent browser from zooming
window.addEventListener('DOMMouseScroll', function(evt) {
  if (evt.ctrlKey) {
    evt.preventDefault();

    var ticks = evt.detail;
    var direction = (ticks > 0) ? 'zoomOut' : 'zoomIn';
    for (var i = 0, length = Math.abs(ticks); i < length; i++)
      PDFView[direction]();
  } else if (PDFView.isFullscreen) {
    var FIREFOX_DELTA_FACTOR = -40;
    PDFView.mouseScroll(evt.detail * FIREFOX_DELTA_FACTOR);
  }
}, false);

window.addEventListener('mousemove', function keydown(evt) {
  if (PDFView.isFullscreen) {
    PDFView.showPresentationControls();
  }
}, false);

window.addEventListener('mousedown', function mousedown(evt) {
  if (PDFView.isFullscreen && evt.button === 0) {
    // Mouse click in fullmode advances a page
    evt.preventDefault();

    PDFView.page++;
  }
}, false);

window.addEventListener('keydown', function keydown(evt) {
  var handled = false;
  var cmd = (evt.ctrlKey ? 1 : 0) |
            (evt.altKey ? 2 : 0) |
            (evt.shiftKey ? 4 : 0) |
            (evt.metaKey ? 8 : 0);

  // First, handle the key bindings that are independent whether an input
  // control is selected or not.
  if (cmd == 1 || cmd == 8) { // either CTRL or META key.
    switch (evt.keyCode) {
      case 70:
        if (!PDFView.supportsIntegratedFind) {
          PDFFindBar.toggle();
          handled = true;
        }
        break;
      case 61: // FF/Mac '='
      case 107: // FF '+' and '='
      case 187: // Chrome '+'
      case 171: // FF with German keyboard
        PDFView.zoomIn();
        handled = true;
        break;
      case 173: // FF/Mac '-'
      case 109: // FF '-'
      case 189: // Chrome '-'
        PDFView.zoomOut();
        handled = true;
        break;
      case 48: // '0'
      case 96: // '0' on Numpad of Swedish keyboard
        PDFView.parseScale(DEFAULT_SCALE, true);
        handled = true;
        break;
    }
  }

  // CTRL or META with or without SHIFT.
  if (cmd == 1 || cmd == 8 || cmd == 5 || cmd == 12) {
    switch (evt.keyCode) {
      case 71: // g
        if (!PDFView.supportsIntegratedFind) {
          PDFFindBar.dispatchEvent('again', cmd == 5 || cmd == 12);
          handled = true;
        }
        break;
    }
  }

  if (handled) {
    evt.preventDefault();
    return;
  }

  // Some shortcuts should not get handled if a control/input element
  // is selected.
  var curElement = document.activeElement;
  if (curElement && (curElement.tagName == 'INPUT' ||
                     curElement.tagName == 'SELECT')) {
    return;
  }
  var controlsElement = document.getElementById('toolbar');
  while (curElement) {
    if (curElement === controlsElement && !PDFView.isFullscreen)
      return; // ignoring if the 'toolbar' element is focused
    curElement = curElement.parentNode;
  }

  if (cmd == 0) { // no control key pressed at all.
    switch (evt.keyCode) {
      case 38: // up arrow
      case 33: // pg up
      case 8: // backspace
        if (!PDFView.isFullscreen && PDFView.currentScaleValue !== 'page-fit') {
          break;
        }
        //  in fullscreen mode falls throw here
      case 37: // left arrow
        // horizontal scrolling using arrow keys
        if (PDFView.isHorizontalScrollbarEnabled) {
          break;
        }
      case 75: // 'k'
      case 80: // 'p'
        PDFView.page--;
        handled = true;
        break;
      case 40: // down arrow
      case 34: // pg down
      case 32: // spacebar
        if (!PDFView.isFullscreen && PDFView.currentScaleValue !== 'page-fit') {
          break;
        }
        //  in fullscreen mode falls throw here
      case 39: // right arrow
        // horizontal scrolling using arrow keys
        if (PDFView.isHorizontalScrollbarEnabled) {
          break;
        }
      case 74: // 'j'
      case 78: // 'n'
        PDFView.page++;
        handled = true;
        break;

      case 36: // home
        if (PDFView.isFullscreen) {
          PDFView.page = 1;
          handled = true;
        }
        break;
      case 35: // end
        if (PDFView.isFullscreen) {
          PDFView.page = PDFView.pdfDocument.numPages;
          handled = true;
        }
        break;

      case 82: // 'r'
        PDFView.rotatePages(90);
        break;
    }
  }

  if (cmd == 4) { // shift-key
    switch (evt.keyCode) {
      case 82: // 'r'
        PDFView.rotatePages(-90);
        break;
    }
  }

  if (handled) {
    evt.preventDefault();
    PDFView.clearMouseScrollState();
  }
});

window.addEventListener('beforeprint', function beforePrint(evt) {
  PDFView.beforePrint();
});

window.addEventListener('afterprint', function afterPrint(evt) {
  PDFView.afterPrint();
});

(function fullscreenClosure() {
  function fullscreenChange(e) {
    var isFullscreen = document.fullscreenElement || document.mozFullScreen ||
        document.webkitIsFullScreen;

    if (!isFullscreen) {
      PDFView.exitFullscreen();
    }
  }

  window.addEventListener('fullscreenchange', fullscreenChange, false);
  window.addEventListener('mozfullscreenchange', fullscreenChange, false);
  window.addEventListener('webkitfullscreenchange', fullscreenChange, false);
})();

(function animationStartedClosure() {
  // The offsetParent is not set until the pdf.js iframe or object is visible.
  // Waiting for first animation.
  var requestAnimationFrame = window.requestAnimationFrame ||
                              window.mozRequestAnimationFrame ||
                              window.webkitRequestAnimationFrame ||
                              window.oRequestAnimationFrame ||
                              window.msRequestAnimationFrame ||
                              function startAtOnce(callback) { callback(); };
  PDFView.animationStartedPromise = new PDFJS.Promise();
  requestAnimationFrame(function onAnimationFrame() {
    PDFView.animationStartedPromise.resolve();
  });
})();

//#if B2G
//window.navigator.mozSetMessageHandler('activity', function(activity) {
//  var url = activity.source.data.url;
//  PDFView.open(url);
//  var cancelButton = document.getElementById('activityClose');
//  cancelButton.addEventListener('click', function() {
//    activity.postResult('close');
//  });
//});
//#endif
